#include "SliderControl.h"

//******************************************************************************
//
//	File:		InstantiateBView.h
//
//	Description:	Unarchiving a BView instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include "View.h"

#pragma export on
SliderControl* InstantiateSliderControl(BMessage *message);
#pragma export off
SliderControl* InstantiateSliderControl(BMessage *message)
{

	SliderControl *instance;
	BRect		frame;
	long		follow;
	float		value;
	rgb_color	color;
const	char		*fontName = NULL;
	
	// Default values
	
	frame.left = 10;
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 30;
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;

	color.red = 210;
	color.green = 210;
	color.blue = 210;
	
	// Decode instance values
	
	if (message->HasPoint("Origin")) {
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	
	if (message->HasData("View Color",B_RGB_COLOR_TYPE)) {
		long size;
		color = *((rgb_color *) message->FindData("View Color",B_RGB_COLOR_TYPE,&size));			// Color
	}
	else {
		message->AddData("View Color",B_RGB_COLOR_TYPE,(const void *)(&color),sizeof(rgb_color));
	}


	if (message->HasString("Font Name")) {
		fontName = message->FindString("Font Name");
	}	

	instance = new SliderControl(frame,"BView",follow,B_FULL_UPDATE_ON_RESIZE|B_WILL_DRAW);
	
	instance->SetViewColor(color);
	instance->SetLowColor(color);
	
	if (fontName != NULL) instance->SetFontName(fontName);
	
	return instance;
}